@REM *************************************************************
@REM This script uninstalls JRE and Mirth Connect in a silent mode
@REM 
@REM Version: 1.0.0.0
@REM Author: Harris Development Team (Vu Le)
@REM History:
@REM	- Initial Version
@REM *************************************************************
@echo off
setlocal

if [%1] equ [] (
   @echo.
   @echo Missing an environment name
   @echo.
   @echo Usage: install.cmd [environment]
   @echo where environment is a name of a sub directory containing
   @echo configuration files and scripts to configure a fully 
   @echo functional Mirth Connect Server instance.
   @echo.
   @echo For instance: install.cmd local
   @echo.
   goto end
)

set ENV_DIR=%cd%\env\%1

if not exist "%ENV_DIR%" (
   @echo.
   @echo Missing "%ENV_DIR%" directory
   @echo.
   goto end
)

if not exist "%ENV_DIR%\server.properties" (
   @echo.
   @echo %ENV_DIR%\server.properties
   @echo.
   goto end
)
if not exist "%ENV_DIR%\mirth.properties" (
   @echo.
   @echo %ENV_DIR%\mirth.properties
   @echo.
   goto end
)
if not exist "%ENV_DIR%\mirth-cli-config.properties" (
   @echo.
   @echo %ENV_DIR%\mirth-cli-config.properties
   @echo.
   goto end
)

if not exist "%ENV_DIR%\sqwm.properties" (
   @echo.
   @echo %ENV_DIR%\sqwm.properties
   @echo.
   goto end
)

if not exist "%ENV_DIR%\sqwm.xml" (
   @echo.
   @echo %ENV_DIR%\sqwm.xml
   @echo.
   goto end
)

FOR /F "eol=; tokens=2,2 delims==" %%i IN ('findstr /i "sys.installationDir" %ENV_DIR%\server.properties') DO set sys.installationDir=%%i
"%sys.installationDir%"\uninstall.exe -q -varfile "%ENV_DIR%\server.properties" -console -Dinstall4j.keepLog=true

FOR /F "eol=; tokens=2,2 delims==" %%i IN ('findstr /i "JRE_INSTALLER" %ENV_DIR%\server.properties') DO set JRE_INSTALLER=%%i
@echo Uninstalling %JRE_INSTALLER%
MsiExec.exe /X{26A24AE4-039D-4CA4-87B4-2F86417007F0} /qn

:end
endlocal